/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.StatusMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.AbstractItemMetadataSelectionStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMetadataLoggingStage
extends AbstractItemMetadataSelectionStage {
    private final Logger log = LoggerFactory.getLogger(StatusMetadataLoggingStage.class);

    @Override
    protected void doExecute(Collection<Item<?>> itemCollection, Item<?> matchingItem, Map<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> matchingMetadata) throws StageProcessingException {
        String itemId = this.getItemIdentifierStrategy().getItemIdentifier(matchingItem);
        List<? extends ItemMetadata> statuses = matchingMetadata.get(InfoStatus.class);
        if (statuses != null && !statuses.isEmpty() && this.log.isInfoEnabled()) {
            this.log.info("Item {} was marked with the following Info status messages", (Object)itemId);
            for (StatusMetadata statusMetadata : statuses) {
                this.log.info("    {} reported: {}", (Object)statusMetadata.getComponentId(), (Object)statusMetadata.getStatusMessage());
            }
        }
        if ((statuses = matchingMetadata.get(WarningStatus.class)) != null && !statuses.isEmpty() && this.log.isWarnEnabled()) {
            this.log.warn("Item {} was marked with the following Warning status messages", (Object)itemId);
            for (StatusMetadata statusMetadata : statuses) {
                this.log.warn("    {} reported: {}", (Object)statusMetadata.getComponentId(), (Object)statusMetadata.getStatusMessage());
            }
        }
        if ((statuses = matchingMetadata.get(ErrorStatus.class)) != null && !statuses.isEmpty() && this.log.isErrorEnabled()) {
            this.log.error("Item {} was marked with the following Error status messages", (Object)itemId);
            for (StatusMetadata statusMetadata : statuses) {
                this.log.error("    {} reported: {}", (Object)statusMetadata.getComponentId(), (Object)statusMetadata.getStatusMessage());
            }
        }
    }
}

