/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ClassToInstanceMultiMap<B> {
    private final boolean indexSupertypes;
    private final HashMap<Class<?>, List<B>> backingMap = new HashMap();
    private final List<B> values = new ArrayList<B>();

    public ClassToInstanceMultiMap() {
        this(false);
    }

    public ClassToInstanceMultiMap(boolean isIndexingSupertypes) {
        this.indexSupertypes = isIndexingSupertypes;
    }

    public void clear() {
        this.values.clear();
        this.backingMap.clear();
    }

    public boolean containsKey(Class<?> key) {
        if (key == null) {
            return false;
        }
        return this.backingMap.containsKey(key);
    }

    public boolean containsValue(B value) {
        if (value == null) {
            return false;
        }
        return this.values.contains(value);
    }

    public <T> List<T> get(Class<T> type) {
        if (type == null) {
            return Collections.emptyList();
        }
        List<B> indexedValues = this.backingMap.get(type);
        if (indexedValues == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(indexedValues);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Set<Class<?>> keys() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    public void put(B value) {
        if (value == null) {
            return;
        }
        if (!this.values.contains(value)) {
            this.values.add(value);
        }
        ArrayList valueTypes = new ArrayList();
        valueTypes.add(value.getClass());
        if (this.indexSupertypes) {
            this.getSuperTypes(value.getClass(), valueTypes);
        }
        for (Class clazz : valueTypes) {
            List<B> indexValues = this.backingMap.get(clazz);
            if (indexValues == null) {
                indexValues = new ArrayList<B>();
                this.backingMap.put(clazz, indexValues);
            }
            indexValues.add(value);
        }
    }

    public void putAll(Iterable<? extends B> newValues) {
        if (newValues == null) {
            return;
        }
        for (B value : newValues) {
            this.put(value);
        }
    }

    public void putAll(ClassToInstanceMultiMap<? extends B> newValues) {
        if (newValues == null) {
            return;
        }
        for (B value : newValues.values()) {
            this.put(value);
        }
    }

    public Collection<? extends B> values() {
        return Collections.unmodifiableList(this.values);
    }

    private void getSuperTypes(Class<?> clazz, ArrayList<Class<?>> accumulator) {
        Class<?>[] interfaces;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            accumulator.add(superclass);
            this.getSuperTypes(superclass, accumulator);
        }
        if ((interfaces = clazz.getInterfaces()).length > 0) {
            for (Class<?> iface : interfaces) {
                accumulator.add(iface);
                this.getSuperTypes(iface, accumulator);
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

