/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.util.Collection;
import java.util.Iterator;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.util.ClassToInstanceMultiMap;
import org.opensaml.util.Assert;
import org.opensaml.util.collections.LazyList;

public class ItemCollectionWithMetadata<ItemType extends Item>
implements Collection<ItemType> {
    private final Collection<ItemType> delegate;
    private final ClassToInstanceMultiMap<ItemMetadata> metadata;

    public ItemCollectionWithMetadata() {
        this.delegate = new LazyList();
        this.metadata = new ClassToInstanceMultiMap(true);
    }

    public ItemCollectionWithMetadata(Collection<ItemType> wrappedCollection) {
        Assert.isNotNull(wrappedCollection, (String)"Wrapped collection can not be null");
        this.delegate = wrappedCollection;
        this.metadata = new ClassToInstanceMultiMap(true);
    }

    public <T extends Collection<ItemType>> T unwrap() {
        return (T)this.delegate;
    }

    public ClassToInstanceMultiMap<ItemMetadata> getCollectionMetadata() {
        return this.metadata;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<ItemType> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(ItemType e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ItemType> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

