/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.util.Collection;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.util.ItemCollectionWithMetadata;

public final class ItemMetadataSupport {
    private ItemMetadataSupport() {
    }

    public static void addToAll(Collection<? extends Item> itemCollection, ItemMetadata ... metadatas) {
        if (itemCollection == null || metadatas == null || metadatas.length == 0) {
            return;
        }
        for (Item item : itemCollection) {
            ItemMetadataSupport.addToAll(item, metadatas);
        }
    }

    public static void addToAll(Item<?> item, ItemMetadata ... metadatas) {
        if (item == null || metadatas == null || metadatas.length == 0) {
            return;
        }
        for (ItemMetadata info : metadatas) {
            item.getItemMetadata().put(info);
        }
    }

    public static void addToCollection(Collection<? extends Item> itemCollection, ItemMetadata ... itemMetadatas) {
        if (itemCollection == null || !(itemCollection instanceof ItemCollectionWithMetadata) || itemMetadatas == null || itemMetadatas.length == 0) {
            return;
        }
        ItemCollectionWithMetadata collection = (ItemCollectionWithMetadata)itemCollection;
        for (ItemMetadata metadata : itemMetadatas) {
            collection.getCollectionMetadata().put(metadata);
        }
    }
}

