/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseDomTest {
    private BasicParserPool parserPool;

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public Element readTestRelativeXmlData(Class classBeingTested, String dataFile) throws XMLParserException {
        StringBuilder absoluteDataPath = new StringBuilder();
        absoluteDataPath.append("/").append(classBeingTested.getName().replace('.', '/'));
        absoluteDataPath.append("/").append(dataFile);
        InputStream input = BaseDomTest.class.getResourceAsStream(absoluteDataPath.toString());
        if (input == null) {
            throw new XMLParserException(absoluteDataPath + " does not exist or is not readable");
        }
        return this.parserPool.parse(input).getDocumentElement();
    }

    public Element readXmlData(String path) throws XMLParserException {
        InputStream input;
        String trimmedPath = StringSupport.trimOrNull((String)path);
        Constraint.isNotNull((Object)trimmedPath, (String)"Path may not be null or empty");
        if (!trimmedPath.startsWith("/")) {
            trimmedPath = "/data/" + trimmedPath;
        }
        if ((input = BaseDomTest.class.getResourceAsStream(trimmedPath)) == null) {
            throw new XMLParserException(trimmedPath + " does not exist or is not readable");
        }
        return this.parserPool.parse(input).getDocumentElement();
    }

    public void assertXmlIdentical(Node expected, Node actual) {
        Constraint.isNotNull((Object)expected, (String)"Expected Node may not be null");
        Constraint.isNotNull((Object)actual, (String)"Actual Node may not be null");
        Diff diff = new Diff(expected.getOwnerDocument(), actual.getOwnerDocument());
        if (!diff.identical()) {
            Assert.fail((String)diff.toString());
        }
    }
}

