/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.shibboleth.metadata.dom.DomResourceSourceStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpResource;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DomResourceSourceTest {
    @Test
    public void testSuccessfulFetchAndParse() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://metadata.ukfederation.org.uk/ukfederation-metadata.xml");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testSuccessfulFetchAndFailedParse() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://www.google.com/intl/en/images/about_logo.gif");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        source.initialize();
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new ConstraintViolationException("Invalid URL marked as parsed");
        }
        catch (StageProcessingException e) {
            return;
        }
    }

    @Test
    public void testFailedFetch() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://kslkjf.com/lkjlk3.dlw");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        try {
            source.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException e) {
            // empty catch block
        }
    }

    protected HttpResource buildHttpResource(String url) throws IOException {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setConnectionDisregardSslCertificate(true);
        builder.setConnectionStalecheck(false);
        File tmp = File.createTempFile(Long.toString(System.currentTimeMillis()), null);
        tmp.deleteOnExit();
        return new HttpResource(builder.buildClient(), url);
    }
}

