/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.ElementFormattingStage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementFormattingStageTest
extends BaseDomTest {
    private Element unformattedElement;
    private Element singleLineElement;
    private Element prettyPrintElement;

    @BeforeClass
    public void setup() throws Exception {
        this.unformattedElement = this.readTestRelativeXmlData(ElementFormattingStage.class, "unformatted.xml");
        this.singleLineElement = this.readTestRelativeXmlData(ElementFormattingStage.class, "singleLine.xml");
        this.prettyPrintElement = this.readTestRelativeXmlData(ElementFormattingStage.class, "prettyPrint.xml");
    }

    @Test
    public void testLineSeperator() throws ComponentInitializationException {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        Assert.assertEquals((String)stage.getLineSeparator(), (String)"\n");
        stage.setLineSeparator("\r\n");
        Assert.assertEquals((String)stage.getLineSeparator(), (String)"\r\n");
        stage.setLineSeparator("");
        Assert.assertEquals((String)stage.getLineSeparator(), (String)"");
        stage.setLineSeparator(null);
        Assert.assertEquals((String)stage.getLineSeparator(), (String)"");
        stage.initialize();
        try {
            stage.setLineSeparator("\n");
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertEquals((String)stage.getLineSeparator(), (String)"");
        }
        stage = new ElementFormattingStage();
        stage.destroy();
        try {
            stage.setLineSeparator(null);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testIndented() throws ComponentInitializationException {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        Assert.assertTrue((boolean)stage.isIndented());
        stage.setIndented(false);
        Assert.assertFalse((boolean)stage.isIndented());
        stage.initialize();
        try {
            stage.setIndented(true);
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertFalse((boolean)stage.isIndented());
        }
        stage = new ElementFormattingStage();
        stage.destroy();
        try {
            stage.setIndented(true);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testIndentSize() throws ComponentInitializationException {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        Assert.assertEquals((int)stage.getIndentSize(), (int)4);
        stage.setIndentSize(10);
        Assert.assertEquals((int)stage.getIndentSize(), (int)10);
        try {
            stage.setIndentSize(-10);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((int)stage.getIndentSize(), (int)10);
        }
        stage.initialize();
        try {
            stage.setIndentSize(2);
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertEquals((int)stage.getIndentSize(), (int)10);
        }
        stage = new ElementFormattingStage();
        stage.destroy();
        try {
            stage.setIndentSize(5);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testCdataSectionElements() throws ComponentInitializationException {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        Assert.assertNotNull((Object)stage.getCdataSectionElements());
        Assert.assertTrue((boolean)stage.getCdataSectionElements().isEmpty());
        stage.setCdataSectionElements((List)Lists.newArrayList((Object[])new String[]{"foo", null, "", "bar"}));
        Assert.assertEquals((int)stage.getCdataSectionElements().size(), (int)2);
        Assert.assertTrue((boolean)stage.getCdataSectionElements().contains("foo"));
        Assert.assertTrue((boolean)stage.getCdataSectionElements().contains("bar"));
        stage.setCdataSectionElements(Collections.EMPTY_LIST);
        Assert.assertTrue((boolean)stage.getCdataSectionElements().isEmpty());
        try {
            stage.getCdataSectionElements().add("foo");
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        stage.initialize();
        try {
            stage.setCdataSectionElements(null);
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertTrue((boolean)stage.getCdataSectionElements().isEmpty());
        }
        stage = new ElementFormattingStage();
        stage.destroy();
        try {
            stage.setCdataSectionElements(null);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleLineFormatting() throws Exception {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        stage.setIndented(false);
        stage.setLineSeparator(null);
        stage.initialize();
        ArrayList itemCollection = Lists.newArrayList((Object[])new DomElementItem[]{new DomElementItem(this.unformattedElement)});
        stage.execute((Collection)itemCollection);
        Assert.assertEquals((int)itemCollection.size(), (int)1);
        DomElementItem result = (DomElementItem)itemCollection.get(0);
        this.assertXmlIdentical(this.singleLineElement, (Node)result.unwrap());
        System.out.print(SerializeSupport.nodeToString((Node)((Node)result.unwrap())));
    }

    @Test
    public void testPrettyPrintFormatting() throws Exception {
        ElementFormattingStage stage = new ElementFormattingStage();
        stage.setId("foo");
        stage.setIndented(true);
        stage.setLineSeparator("\n");
        stage.setIndentSize(4);
        stage.initialize();
        ArrayList itemCollection = Lists.newArrayList((Object[])new DomElementItem[]{new DomElementItem(this.unformattedElement)});
        stage.execute((Collection)itemCollection);
        Assert.assertEquals((int)itemCollection.size(), (int)1);
        DomElementItem result = (DomElementItem)itemCollection.get(0);
        this.assertXmlIdentical(this.prettyPrintElement, (Node)result.unwrap());
        System.out.print(SerializeSupport.nodeToString((Node)((Node)result.unwrap())));
    }
}

