/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XMLSchemaValidationStage;
import net.shibboleth.utilities.java.support.resource.FilesystemResource;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XMLSchemaValidationStageTest {
    @Test
    public void testValidXml() throws Exception {
        XMLSchemaValidationStage stage = this.buildStage();
        Collection<DomElementItem> mdCol = this.buildMetdataCollection("/data/xmlSchemaValidationStageValidInput.xml");
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
    }

    @Test
    public void testInvalidXml() throws Exception {
        XMLSchemaValidationStage stage = this.buildStage();
        Collection<DomElementItem> mdCol = this.buildMetdataCollection("/data/xmlSchemaValidationStageInvalidInput.xml");
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Assert.assertTrue((boolean)mdCol.iterator().next().getItemMetadata().containsKey(ErrorStatus.class));
    }

    protected XMLSchemaValidationStage buildStage() throws Exception {
        String schemaFile = new File(XMLSchemaValidationStageTest.class.getResource("/data/xmlSchemaValidationStage.xsd").toURI()).getAbsolutePath();
        ArrayList<FilesystemResource> schemaResources = new ArrayList<FilesystemResource>();
        schemaResources.add(new FilesystemResource(schemaFile));
        XMLSchemaValidationStage stage = new XMLSchemaValidationStage();
        stage.setId("test");
        stage.setSchemaResources(schemaResources);
        stage.initialize();
        return stage;
    }

    protected Collection<DomElementItem> buildMetdataCollection(String xmlPath) throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document doc = parserPool.parse(XMLSchemaValidationStageTest.class.getResourceAsStream(xmlPath));
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(new DomElementItem(doc.getDocumentElement()));
        return mdCol;
    }
}

