/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XPathFilteringStage;
import net.shibboleth.utilities.java.support.xml.SimpleNamespaceContext;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class XPathFilteringStageTest
extends BaseDomTest {
    @Test
    public void testExecute() throws Exception {
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        prefixMappings.put("ukfedlabel", "http://ukfederation.org.uk/2006/11/label");
        XPathFilteringStage strategy = new XPathFilteringStage();
        strategy.setXpathExpression("//ukfedlabel:DeletedEntity");
        strategy.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(prefixMappings));
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("xpathInput1.xml")));
        metadataCollection.add(new DomElementItem(this.readXmlData("xpathInput2.xml")));
        metadataCollection.add(new DomElementItem(this.readXmlData("xpathInput3.xml")));
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        strategy.doExecute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        Element element = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        String id = element.getAttribute("id");
        Assert.assertEquals((String)id, (String)"entity2");
    }
}

