/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XSLTransformationStage;
import net.shibboleth.utilities.java.support.resource.ClasspathResource;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTtransformationStageTest
extends BaseDomTest {
    private DomElementItem makeInput() throws XMLParserException {
        Element testInput = this.readXmlData("xsltStageInput.xml");
        DomElementItem metadata = new DomElementItem(testInput);
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)0);
        metadata.getItemMetadata().put((Object)new TestInfo());
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)1);
        return metadata;
    }

    @Test
    public void testTransform1() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xsltStageTransform1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXmlData("xsltStageOutput.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testTransformParam() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xsltStageTransform1.xsl");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fruit", "avocados");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.setTransformParameters(params);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXmlData("xsltStageParamOutput.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testTransformListener() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xsltStageTransformListener1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        HashSet<String> names = new HashSet<String>();
        for (DomElementItem result : mdCol) {
            AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
            Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
            names.add(((Element)result.unwrap()).getNodeName());
            List infos = result.getItemMetadata().get(InfoStatus.class);
            Assert.assertEquals((int)infos.size(), (int)2);
            Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"second value");
            Assert.assertEquals((String)((InfoStatus)infos.get(1)).getStatusMessage(), (String)"second value second message");
            List warnings = result.getItemMetadata().get(WarningStatus.class);
            Assert.assertEquals((int)warnings.size(), (int)1);
            Assert.assertEquals((String)((WarningStatus)warnings.get(0)).getStatusMessage(), (String)"first value");
            List errors = result.getItemMetadata().get(ErrorStatus.class);
            Assert.assertEquals((int)errors.size(), (int)1);
            Assert.assertEquals((String)((ErrorStatus)errors.get(0)).getStatusMessage(), (String)"error value");
        }
        Assert.assertFalse((boolean)names.contains("firstValue"));
        Assert.assertTrue((boolean)names.contains("secondValue"));
    }

    @Test
    public void testInclude() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xslIncludeMain.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXmlData("xsltStageOutput.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testOutsideDocumentElement() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xsltStageTransform1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXmlData("xsltStageOutput.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
        Node firstNode = ((Element)result.unwrap()).getOwnerDocument().getFirstChild();
        Assert.assertEquals((short)firstNode.getNodeType(), (short)8);
        Assert.assertEquals((String)firstNode.getNodeValue(), (String)"this is a comment");
    }

    private static class TestInfo
    implements ItemMetadata {
        private static final long serialVersionUID = -4133926323393787487L;

        private TestInfo() {
        }
    }
}

