/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XSLValidationStage;
import net.shibboleth.utilities.java.support.resource.ClasspathResource;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLValidationStageTest
extends BaseDomTest {
    private DomElementItem makeInput() throws XMLParserException {
        Element testInput = this.readXmlData("xsltStageInput.xml");
        DomElementItem metadata = new DomElementItem(testInput);
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)0);
        metadata.getItemMetadata().put((Object)new TestInfo());
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)1);
        return metadata;
    }

    @Test
    public void testValidation() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/xslValidator.xsl");
        XSLValidationStage stage = new XSLValidationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.get(0);
        Element expected = this.readXmlData("xsltStageInput.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
        AssertSupport.assertValidComponentInfo(result, 1, XSLValidationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        List infos = result.getItemMetadata().get(InfoStatus.class);
        Assert.assertEquals((int)infos.size(), (int)2);
        Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"second value");
        Assert.assertEquals((String)((InfoStatus)infos.get(1)).getStatusMessage(), (String)"second value second message");
        List warnings = result.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)warnings.size(), (int)1);
        Assert.assertEquals((String)((WarningStatus)warnings.get(0)).getStatusMessage(), (String)"first value");
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)1);
        Assert.assertEquals((String)((ErrorStatus)errors.get(0)).getStatusMessage(), (String)"error value");
    }

    @Test
    public void testMDA45() throws Exception {
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(this.makeInput());
        ClasspathResource transform = new ClasspathResource("data/mda45.xsl");
        XSLValidationStage stage = new XSLValidationStage();
        stage.setId("test");
        stage.setXslResource((Resource)transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.get(0);
        List infos = result.getItemMetadata().get(InfoStatus.class);
        Assert.assertEquals((int)infos.size(), (int)1);
        Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"values");
    }

    private static class TestInfo
    implements ItemMetadata {
        private static final long serialVersionUID = -4133926323393787487L;

        private TestInfo() {
        }
    }
}

