/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.EntitiesDescriptorAssemblerStage;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntitiesDescriptorAssemblerStageTest
extends BaseDomTest {
    @Test
    public void testAssemblingWithoutName() throws Exception {
        Collection<DomElementItem> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Document result = ((Element)metadataCollection.iterator().next().unwrap()).getOwnerDocument();
        this.assertXmlIdentical(this.readXmlData("samlMetadata/entitiesDescriptor2.xml"), result);
    }

    @Test
    public void testAssemblingWithName() throws Exception {
        Collection<DomElementItem> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        stage.setDescriptorName("nameValue");
        stage.initialize();
        stage.execute(metadataCollection);
        Document result = ((Element)metadataCollection.iterator().next().unwrap()).getOwnerDocument();
        this.assertXmlIdentical(this.readXmlData("samlMetadata/entitiesDescriptor2Name.xml"), result);
    }

    @Test
    public void testAssemblingWithOrdering() throws Exception {
        Collection<DomElementItem> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        class ReverseOrder
        implements EntitiesDescriptorAssemblerStage.ItemOrderingStrategy {
            ReverseOrder() {
            }

            public List<DomElementItem> order(Collection<DomElementItem> items) {
                ArrayList<DomElementItem> result = new ArrayList<DomElementItem>(items);
                Collections.reverse(result);
                return result;
            }
        }
        stage.setItemOrderingStrategy((EntitiesDescriptorAssemblerStage.ItemOrderingStrategy)new ReverseOrder());
        stage.initialize();
        stage.execute(metadataCollection);
        Document result = ((Element)metadataCollection.iterator().next().unwrap()).getOwnerDocument();
        this.assertXmlIdentical(this.readXmlData("samlMetadata/entitiesDescriptor2Reversed.xml"), result);
    }

    protected Collection<DomElementItem> buildMetadataCollection() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        Element descriptor = this.readXmlData("samlMetadata/entityDescriptor1.xml");
        metadataCollection.add(new DomElementItem(descriptor));
        descriptor = this.readXmlData("samlMetadata/entityDescriptor2.xml");
        metadataCollection.add(new DomElementItem(descriptor));
        Element fooElement = this.getParserPool().newDocument().createElement("foo");
        metadataCollection.add(new DomElementItem(fooElement));
        return metadataCollection;
    }
}

