/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.EntityDescriptorItemIdPopulationStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class EntityDescriptorItemIdPopulationStageTest
extends BaseDomTest {
    @Test
    public void testEmptyCollection() throws Exception {
        ArrayList metadataCollection = new ArrayList();
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertTrue((boolean)metadataCollection.isEmpty());
    }

    @Test
    public void testDifferentElement() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        List itemIds = ((DomElementItem)metadataCollection.get(0)).getItemMetadata().get(ItemId.class);
        Assert.assertEquals((int)itemIds.size(), (int)0);
    }

    @Test
    public void testSingleRecord() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entityDescriptor1.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        DomElementItem item = (DomElementItem)metadataCollection.get(0);
        Element entityDescriptor = (Element)item.unwrap();
        List itemIds = item.getItemMetadata().get(ItemId.class);
        Assert.assertEquals((int)itemIds.size(), (int)1);
        ItemId itemId = (ItemId)itemIds.get(0);
        Assert.assertEquals((String)itemId.getId(), (String)entityDescriptor.getAttributeNS(null, "entityID"));
    }

    @Test
    public void testMultipleRecords() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entityDescriptor1.xml")));
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entityDescriptor2.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
        for (DomElementItem item : metadataCollection) {
            Element entityDescriptor = (Element)item.unwrap();
            List itemIds = item.getItemMetadata().get(ItemId.class);
            Assert.assertEquals((int)itemIds.size(), (int)1);
            ItemId itemId = (ItemId)itemIds.get(0);
            Assert.assertEquals((String)itemId.getId(), (String)entityDescriptor.getAttributeNS(null, "entityID"));
        }
    }
}

