/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.EntityFilterStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityFilterStageTest
extends BaseDomTest {
    @Test
    public void testEntityWhitelist() throws Exception {
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities((Collection)Lists.newArrayList((Object[])new String[]{"https://idp.shibboleth.net/idp/shibboleth"}));
        stage.setWhitelistingEntities(true);
        stage.initialize();
        Collection<DomElementItem> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testEntityBlacklist() throws Exception {
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities((Collection)Lists.newArrayList((Object[])new String[]{"https://idp.shibboleth.net/idp/shibboleth"}));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        Collection<DomElementItem> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
    }

    @Test
    public void testEntitiesDescriptorFiltering() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities((Collection)Lists.newArrayList((Object[])new String[]{"https://idp.shibboleth.net/idp/shibboleth"}));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.iterator().next()).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)entitiesDescriptor).size(), (int)2);
    }

    @Test
    public void testRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities((Collection)Lists.newArrayList((Object[])new String[]{"https://idp.shibboleth.net/idp/shibboleth", "https://issues.shibboleth.net/shibboleth", "https://wiki.shibboleth.net/shibboleth"}));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)0);
    }

    @Test
    public void testDontRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setRemovingEntitylessEntitiesDescriptor(false);
        stage.setDesignatedEntities((Collection)Lists.newArrayList((Object[])new String[]{"https://idp.shibboleth.net/idp/shibboleth", "https://issues.shibboleth.net/shibboleth", "https://wiki.shibboleth.net/shibboleth"}));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    private Collection<DomElementItem> buildMetadataCollection() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXmlData("samlMetadata/entitiesDescriptor1.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add(new DomElementItem(descriptor));
        }
        return metadataCollection;
    }
}

