/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.EntityRoleFilterStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityRoleFilterStageTest
extends BaseDomTest {
    @Test
    public void testRoleWhitelist() throws Exception {
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(true);
        stage.initialize();
        List<DomElementItem> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        Element descriptor = (Element)metadataCollection.get(0).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME).size(), (int)1);
    }

    @Test
    public void testRoleBlacklist() throws Exception {
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(false);
        stage.initialize();
        List<DomElementItem> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
        Element descriptor = (Element)metadataCollection.get(0).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)1);
        descriptor = (Element)metadataCollection.get(1).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)1);
    }

    @Test
    public void testDontRemoveRolelessEntityDescriptor() throws Exception {
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(true);
        stage.setRemoveRolelessEntities(false);
        stage.initialize();
        List<DomElementItem> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        Element descriptor = (Element)metadataCollection.get(0).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME).size(), (int)1);
        descriptor = (Element)metadataCollection.get(1).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)0);
        descriptor = (Element)metadataCollection.get(2).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)0);
    }

    @Test
    public void testEntitiesDescriptorFiltering() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(false);
        stage.initialize();
        stage.execute(metadataCollection);
        List descriptors = ElementSupport.getChildElements((Node)((Node)((DomElementItem)metadataCollection.iterator().next()).unwrap()));
        Assert.assertEquals((int)descriptors.size(), (int)2);
        Element descriptor = (Element)descriptors.get(0);
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)1);
        descriptor = (Element)descriptors.get(1);
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)descriptor, (QName)EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME).size(), (int)1);
    }

    @Test
    public void testRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME, EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)0);
    }

    @Test
    public void testDontRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        EntityRoleFilterStage stage = new EntityRoleFilterStage();
        stage.setId("test");
        stage.setDesignatedRoles((Collection)Lists.newArrayList((Object[])new QName[]{EntityRoleFilterStage.IDP_SSO_DESCRIPTOR_NAME, EntityRoleFilterStage.SP_SSO_DESCRIPTOR_NAME}));
        stage.setWhitelistingRoles(false);
        stage.setRemovingEntitylessEntitiesDescriptor(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    private List<DomElementItem> buildMetadataCollection() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXmlData("samlMetadata/entitiesDescriptor1.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add(new DomElementItem(descriptor));
        }
        return metadataCollection;
    }
}

