/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.dom.saml.SetCacheDurationStage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetCacheDurationStageTest {
    @Test
    public void testWithoutExistingCacheDuration() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Element entitiesDescriptor = parserPool.parse(SetCacheDurationStageTest.class.getResourceAsStream("/data/samlMetadata.xml")).getDocumentElement();
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME) == null ? 1 : 0) != 0);
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(entitiesDescriptor));
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)((Element)((DomElementItem)metadataCollection.iterator().next()).unwrap()), (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)cacheDurationAttr);
        Assert.assertEquals((String)cacheDurationAttr.getValue(), (String)"PT2M3.456S");
    }

    @Test
    public void testWithExistingCacheDuration() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Element entitiesDescriptor = parserPool.parse(SetCacheDurationStageTest.class.getResourceAsStream("/data/samlMetadata.xml")).getDocumentElement();
        AttributeSupport.appendDurationAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)987654L);
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME) != null ? 1 : 0) != 0);
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(entitiesDescriptor));
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)cacheDurationAttr);
        Assert.assertEquals((String)cacheDurationAttr.getValue(), (String)"PT16M27.654S");
    }

    @Test
    public void testWithNonDescriptorMetadataElement() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document newDoc = parserPool.newDocument();
        Element root = newDoc.createElementNS("http://example.org", "foo");
        ElementSupport.setDocumentElement((Document)newDoc, (Element)root);
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(root));
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)root, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNull((Object)cacheDurationAttr);
    }

    @Test
    public void testNegativeDuration() {
        long duration = -987654L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        try {
            stage.setCacheDuration(duration);
            stage.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException e) {
            // empty catch block
        }
    }
}

