/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.xml.namespace.QName;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.dom.saml.ValidateValidUntilStage;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class ValidateValidUntilStageTest
extends BaseDomTest {
    @Test
    public void testOptionalCheck() throws Exception {
        ValidateValidUntilStage stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(false);
        stage.initialize();
        DomElementItem item = this.buildDomElementItem(0L);
        stage.doExecute(item);
        Assert.assertFalse((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(true);
        stage.initialize();
        item = this.buildDomElementItem(0L);
        stage.doExecute(item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testValidUntilRangeCheck() throws Exception {
        ValidateValidUntilStage stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(false);
        stage.initialize();
        DomElementItem item = this.buildDomElementItem(10000L);
        stage.doExecute(item);
        Assert.assertFalse((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        item = this.buildDomElementItem(-10000L);
        stage.doExecute(item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        item = this.buildDomElementItem(691200000L);
        stage.doExecute(item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    private DomElementItem buildDomElementItem(long validUntilInterval) throws Exception {
        Element descriptor = this.readXmlData("samlMetadata/entitiesDescriptor1.xml");
        if (validUntilInterval != 0L) {
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME, (long)(System.currentTimeMillis() + validUntilInterval));
        } else {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        }
        return new DomElementItem(descriptor.getOwnerDocument());
    }
}

