/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.AbstractDestructableIdentifiableInitializableComponent;

public class CountingStage<ItemType extends Item<?>>
extends AbstractDestructableIdentifiableInitializableComponent
implements Stage<ItemType> {
    private int invocationCount;
    private int itemCount;

    public CountingStage() {
        this.setId("CountingStage");
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void execute(Collection<ItemType> metadataCollection) throws StageProcessingException {
        ++this.invocationCount;
        this.itemCount += metadataCollection.size();
    }
}

