/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.ItemMetadataFilterStage;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ItemMetadataFilterStageTest {
    private Collection<Item<?>> metadataCollectionPrototype;
    private Item md1;
    private Item md2;
    private Item md3;
    private Item md4;

    @BeforeTest
    public void setup() {
        this.metadataCollectionPrototype = new ArrayList();
        this.md1 = new MockItem("1");
        this.metadataCollectionPrototype.add(this.md1);
        this.md2 = new MockItem("2");
        this.md2.getItemMetadata().put((Object)new WarningStatus("2", "warning"));
        this.metadataCollectionPrototype.add(this.md2);
        this.md3 = new MockItem("3");
        this.metadataCollectionPrototype.add(this.md3);
        this.md4 = new MockItem("4");
        this.md4.getItemMetadata().put((Object)new WarningStatus("4", "warning"));
        this.md4.getItemMetadata().put((Object)new ErrorStatus("4", "error"));
        this.metadataCollectionPrototype.add(this.md4);
    }

    @Test
    public void testNoFilterRequirements() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ItemMetadataFilterStage stage = new ItemMetadataFilterStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)4);
        Assert.assertTrue((boolean)metadataCollection.contains(this.md1));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md2));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md3));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md4));
    }

    @Test
    public void testSingleFilterRequirement() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ArrayList<Class<ErrorStatus>> filterRequirements = new ArrayList<Class<ErrorStatus>>();
        filterRequirements.add(ErrorStatus.class);
        ItemMetadataFilterStage stage = new ItemMetadataFilterStage();
        stage.setId("test");
        stage.setSelectionRequirements(filterRequirements);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        Assert.assertTrue((boolean)metadataCollection.contains(this.md1));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md2));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md3));
        Assert.assertFalse((boolean)metadataCollection.contains(this.md4));
    }

    @Test
    public void testMultiFilterRequirement() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ArrayList<Class<ErrorStatus>> filterRequirements = new ArrayList<Class<ErrorStatus>>();
        filterRequirements.add(InfoStatus.class);
        filterRequirements.add(WarningStatus.class);
        filterRequirements.add(ErrorStatus.class);
        ItemMetadataFilterStage stage = new ItemMetadataFilterStage();
        stage.setId("test");
        stage.setSelectionRequirements(filterRequirements);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
        Assert.assertTrue((boolean)metadataCollection.contains(this.md1));
        Assert.assertFalse((boolean)metadataCollection.contains(this.md2));
        Assert.assertTrue((boolean)metadataCollection.contains(this.md3));
        Assert.assertFalse((boolean)metadataCollection.contains(this.md4));
    }
}

