/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StaticItemSourceStage;
import net.shibboleth.utilities.java.support.component.AbstractDestructableIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimplePipelineTest {
    @Test
    public void testInitialize() throws Exception {
        List<? extends Stage<MockItem>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId(" test ");
        pipeline.setStages(stages);
        Assert.assertEquals((String)pipeline.getId(), (String)"test");
        Assert.assertFalse((pipeline.getStages() == stages ? 1 : 0) != 0);
        Assert.assertEquals((int)pipeline.getStages().size(), (int)3);
        Assert.assertTrue((boolean)pipeline.getStages().containsAll(stages));
        Assert.assertFalse((boolean)((Stage)pipeline.getStages().get(0)).isInitialized());
        Assert.assertFalse((boolean)((Stage)pipeline.getStages().get(1)).isInitialized());
        pipeline.initialize();
        Assert.assertEquals((String)pipeline.getId(), (String)"test");
        Assert.assertFalse((pipeline.getStages() == stages ? 1 : 0) != 0);
        Assert.assertEquals((int)pipeline.getStages().size(), (int)3);
        Assert.assertTrue((boolean)pipeline.getStages().containsAll(stages));
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(0)).isInitialized());
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(1)).isInitialized());
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(2)).isInitialized());
        try {
            pipeline = new SimplePipeline();
            pipeline.setStages(stages);
            pipeline.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException e) {
            // empty catch block
        }
        try {
            pipeline = new SimplePipeline();
            pipeline.setId("");
            pipeline.setStages(stages);
            pipeline.initialize();
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testExecution() throws Exception {
        List<? extends Stage<MockItem>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("test");
        pipeline.setStages(stages);
        pipeline.initialize();
        ArrayList metadata = new ArrayList();
        pipeline.execute(metadata);
        Assert.assertEquals((int)metadata.size(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(1)).getInvocationCount(), (int)1);
        Assert.assertEquals((int)((CountingStage)stages.get(2)).getInvocationCount(), (int)1);
        MockItem md = (MockItem)((Object)metadata.iterator().next());
        Assert.assertTrue((boolean)md.getItemMetadata().containsKey(ComponentInfo.class));
        Assert.assertEquals((int)md.getItemMetadata().values().size(), (int)2);
        Assert.assertTrue((boolean)md.getItemMetadata().containsKey(ComponentInfo.class));
        try {
            List pipelineStages = pipeline.getStages();
            pipelineStages.clear();
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        metadata = new ArrayList();
        pipeline.execute(metadata);
        Assert.assertEquals((int)metadata.size(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(1)).getInvocationCount(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(2)).getInvocationCount(), (int)2);
    }

    protected List<? extends Stage<MockItem>> buildStages() {
        MockItem md1 = new MockItem("one");
        MockItem md2 = new MockItem("two");
        StaticItemSourceStage source = new StaticItemSourceStage();
        source.setId("src");
        source.setSourceItems((Collection)Lists.newArrayList((Object[])new MockItem[]{md1, md2}));
        CountingStage stage1 = new CountingStage();
        CountingStage stage2 = new CountingStage();
        return Lists.newArrayList((Object[])new AbstractDestructableIdentifiableInitializableComponent[]{source, stage1, stage2});
    }
}

