/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.io.Serializable;
import java.util.List;
import net.shibboleth.metadata.util.ClassToInstanceMultiMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClassToInstanceMultiMapTest {
    @Test
    public void testClearIsEmpty() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        map.put(new Object());
        Assert.assertFalse((boolean)map.isEmpty());
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testKeysAndContainsKey() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        Assert.assertEquals((int)map.keys().size(), (int)2);
        Assert.assertFalse((boolean)map.containsKey(null));
        Assert.assertFalse((boolean)map.containsKey(Chronology.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractInstant.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractDateTime.class));
        Assert.assertFalse((boolean)map.containsKey(BaseDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(DateTime.class));
        Assert.assertFalse((boolean)map.containsKey(Comparable.class));
        Assert.assertFalse((boolean)map.containsKey(ReadableDateTime.class));
        Assert.assertFalse((boolean)map.containsKey(ReadableInstant.class));
        Assert.assertFalse((boolean)map.containsKey(Serializable.class));
        Assert.assertTrue((boolean)map.containsKey(Instant.class));
        map = new ClassToInstanceMultiMap(true);
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        Assert.assertEquals((int)map.keys().size(), (int)9);
        Assert.assertFalse((boolean)map.containsKey(null));
        Assert.assertFalse((boolean)map.containsKey(Chronology.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractInstant.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(BaseDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(DateTime.class));
        Assert.assertTrue((boolean)map.containsKey(Comparable.class));
        Assert.assertTrue((boolean)map.containsKey(ReadableDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(ReadableInstant.class));
        Assert.assertTrue((boolean)map.containsKey(Serializable.class));
        Assert.assertTrue((boolean)map.containsKey(Instant.class));
    }

    @Test
    public void testValuesAndContainsValues() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        DateTime now = new DateTime();
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
        Assert.assertEquals((int)map.values().size(), (int)3);
        Assert.assertFalse((boolean)map.containsValue(null));
        Assert.assertFalse((boolean)map.containsValue((Object)now.minus(100L)));
        Assert.assertFalse((boolean)map.containsValue((Object)instant.minus(100L)));
        Assert.assertTrue((boolean)map.containsValue((Object)instant));
        Assert.assertTrue((boolean)map.containsValue((Object)now));
        Assert.assertTrue((boolean)map.containsValue((Object)now100));
    }

    @Test
    public void testEquals() {
    }

    @Test
    public void testGet() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        List values = map.get(null);
        Assert.assertEquals((int)values.size(), (int)0);
        values = map.get(DateTime.class);
        Assert.assertEquals((int)values.size(), (int)2);
        values = map.get(Instant.class);
        Assert.assertEquals((int)values.size(), (int)1);
    }

    protected void populate(ClassToInstanceMultiMap<AbstractInstant> map) {
        DateTime now = new DateTime();
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
    }
}

