/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class FirstItemIdItemIdentificationStrategy
implements ItemIdentificationStrategy {
    private String noItemIdIdentifier = "unidentified";

    public String getNoItemIdIdentifier() {
        return this.noItemIdIdentifier;
    }

    public void setNoItemIdIdentifier(@Nonnull @NotEmpty String identifier) {
        this.noItemIdIdentifier = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)identifier), (String)"Identifier can not be null or empty");
    }

    @Override
    @Nonnull
    public String getItemIdentifier(@Nonnull Item<?> item) {
        Constraint.isNotNull(item, (String)"Item can not equal null");
        List<ItemId> itemIds = item.getItemMetadata().get(ItemId.class);
        if (itemIds != null && !itemIds.isEmpty()) {
            return itemIds.get(0).getId();
        }
        return this.noItemIdIdentifier;
    }
}

