/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ThreadSafe
public class DomElementSerializer
implements ItemSerializer<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(DomElementSerializer.class);

    @Override
    public void serialize(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection, OutputStream output) {
        if (itemCollection == null || itemCollection.isEmpty()) {
            return;
        }
        Element documentRoot = (Element)itemCollection.iterator().next().unwrap();
        try {
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer serializer = tfac.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.transform(new DOMSource(documentRoot.getOwnerDocument()), new StreamResult(output));
        }
        catch (TransformerException e) {
            this.log.error("Unable to write out XML", (Throwable)e);
        }
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            this.log.error("Unable to close output stream", (Throwable)e);
        }
    }
}

