/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.ResourceException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DomResourceSourceStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(DomResourceSourceStage.class);
    private Resource domResource;
    private ParserPool parserPool;
    private boolean errorCausesSourceFailure = true;

    @Nullable
    public Resource getDomResource() {
        return this.domResource;
    }

    public synchronized void setDomResource(@Nonnull Resource resource) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.domResource = (Resource)Constraint.isNotNull((Object)resource, (String)"DOM resource can not be null");
    }

    @Nullable
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(@Nonnull ParserPool pool) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
    }

    public boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.errorCausesSourceFailure = causesFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection) throws StageProcessingException {
        InputStream ins;
        block6: {
            ins = null;
            try {
                this.log.debug("Attempting to fetch XML document from '{}'", (Object)this.domResource.getLocation());
                ins = this.domResource.getInputStream();
                if (ins == null) {
                    this.log.debug("Resource at location '{}' did not produce any data to parse, nothing left to do", (Object)this.domResource.getLocation());
                    break block6;
                }
                this.log.debug("DOM Element from '{}' unchanged since last request, using cached copy", (Object)this.domResource.getLocation());
                this.populateItemCollection(itemCollection, ins);
            }
            catch (ResourceException e) {
                try {
                    if (this.errorCausesSourceFailure) {
                        throw new StageProcessingException("Error retrieving XML document from " + this.domResource.getLocation(), (Exception)((Object)e));
                    }
                    this.log.warn("stage {}: unable to read in XML file");
                    this.log.debug("stage {}: HTTP resource exception", (Object)this.getId(), (Object)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(ins);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)ins);
            }
        }
        Closeables.closeQuietly((Closeable)ins);
    }

    protected void populateItemCollection(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection, InputStream data) throws StageProcessingException {
        try {
            this.log.debug("Parsing XML document retrieved from '{}'", (Object)this.domResource.getLocation());
            itemCollection.add(new DomElementItem(this.parserPool.parse(data)));
        }
        catch (XMLParserException e) {
            if (this.errorCausesSourceFailure) {
                throw new StageProcessingException("Unable to parse returned XML document", (Exception)((Object)e));
            }
            this.log.warn("stage {}: unable to parse XML document", (Object)this.getId());
            this.log.debug("stage {}: parsing exception", (Object)this.getId(), (Object)e);
        }
    }

    protected void doDestroy() {
        this.domResource.destroy();
        this.domResource = null;
        this.parserPool = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.domResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", either a DomResource must be specified");
        }
        if (!this.domResource.isInitialized()) {
            this.domResource.initialize();
        }
        try {
            if (!this.domResource.exists()) {
                throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", DOM resource " + this.domResource.getLocation() + " does not exist");
            }
        }
        catch (ResourceException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading DOM resource " + this.domResource.getLocation() + " information", (Exception)((Object)e));
        }
    }
}

