/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.TrimOrNullStringFunction;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ElementFormattingStage
extends BaseStage<DomElementItem> {
    private String lineSeparator = "\n";
    private boolean indented = true;
    private int indentSize = 4;
    private List<String> cdataSectionElements = Collections.emptyList();
    private TransformerFactory transformerFactory;

    @Nonnull
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public synchronized void setLineSeparator(@Nullable String separator) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lineSeparator = separator == null ? "" : separator;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public synchronized void setIndented(boolean indentElements) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.indented = indentElements;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public synchronized void setIndentSize(int size) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.indentSize = (int)Constraint.isGreaterThanOrEqual((long)0L, (long)size, (String)"Indentation size must be 0 or greater");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<String> getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public synchronized void setCdataSectionElements(@Nullable @NullableElements List<String> elements) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ArrayList checkedElements = new ArrayList();
        CollectionSupport.addIf(checkedElements, elements, (Predicate)Predicates.notNull(), (Function)new TrimOrNullStringFunction());
        this.cdataSectionElements = ImmutableList.copyOf(checkedElements);
    }

    @Override
    protected void doExecute(Collection<DomElementItem> itemCollection) throws StageProcessingException {
        ArrayList transformedItems = Lists.newArrayListWithExpectedSize((int)itemCollection.size());
        for (DomElementItem item : itemCollection) {
            DOMSource source = new DOMSource((Node)item.unwrap());
            DOMResult result = new DOMResult();
            try {
                this.getTransformer().transform(source, result);
                DomElementItem transformedItem = new DomElementItem(((Document)result.getNode()).getDocumentElement());
                ItemMetadataSupport.addAll(transformedItem, item.getItemMetadata().values());
                transformedItems.add(transformedItem);
            }
            catch (TransformerException e) {
                throw new StageProcessingException("Unable to format Element", e);
            }
        }
        itemCollection.clear();
        itemCollection.addAll(transformedItems);
    }

    protected Transformer getTransformer() throws StageProcessingException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", this.lineSeparator);
            if (this.indented) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(this.indentSize));
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.setOutputProperty("cdata-section-elements", StringSupport.listToStringValue(this.cdataSectionElements, (String)","));
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new StageProcessingException("Unable to create a new Transformer", e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.transformerFactory = TransformerFactory.newInstance("org.apache.xalan.processor.TransformerFactoryImpl", this.getClass().getClassLoader());
    }
}

