/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ThreadSafe
public class NamespaceStrippingStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(NamespaceStrippingStage.class);
    private String namespace;

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nonnull @NotEmpty String ns) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ns), (String)"target namespace can not be null or empty");
    }

    private void processItem(@Nonnull DomElementItem item) {
        Element element = (Element)((DomElementItem)Constraint.isNotNull((Object)item, (String)"Item can not be null")).unwrap();
        if (this.namespace.equals(element.getNamespaceURI())) {
            ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
            metadata.put(new ErrorStatus(this.getId(), "can't strip namespace from document element"));
            return;
        }
        this.processElement(element, 0);
    }

    private void processAttributes(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        NamedNodeMap attributes = element.getAttributes();
        ArrayList<Attr> removeTarget = new ArrayList<Attr>();
        ArrayList removePrefix = new ArrayList();
        for (int aIndex = 0; aIndex < attributes.getLength(); ++aIndex) {
            Attr attribute = (Attr)attributes.item(aIndex);
            String attrNamespace = attribute.getNamespaceURI();
            String attrLocalName = attribute.getLocalName();
            this.log.debug("checking attribute {{}}:{}", (Object)attrNamespace, (Object)attrLocalName);
            if (this.namespace.equals(attrNamespace)) {
                this.log.debug("   in target namespace; will remove");
                removeTarget.add(attribute);
                continue;
            }
            if (!"http://www.w3.org/2000/xmlns/".equals(attrNamespace) || !this.namespace.equals(attribute.getTextContent())) continue;
            this.log.debug("   prefix {} definition; will remove", (Object)attrLocalName);
            removeTarget.add(attribute);
        }
        for (Attr a : removeTarget) {
            element.removeAttributeNode(a);
        }
        for (Attr a : removePrefix) {
            element.removeAttributeNode(a);
        }
    }

    private void processElement(@Nonnull Element element, int depth) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        this.log.debug("{}: element {}", (Object)depth, (Object)element.getLocalName());
        if (this.namespace.equals(element.getNamespaceURI())) {
            this.log.debug("{}: removing element entirely", (Object)depth);
            element.getParentNode().removeChild(element);
            return;
        }
        NodeList children = element.getChildNodes();
        for (int eIndex = 0; eIndex < children.getLength(); ++eIndex) {
            Node child = children.item(eIndex);
            if (!(child instanceof Element)) continue;
            this.processElement((Element)child, depth + 1);
        }
        this.processAttributes(element);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<DomElementItem> items) throws StageProcessingException {
        for (DomElementItem item : items) {
            this.processItem(item);
        }
    }

    protected void doDestroy() {
        this.namespace = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.namespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
    }
}

