/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@ThreadSafe
public class XMLSchemaValidationStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XMLSchemaValidationStage.class);
    private List<Resource> schemaResources = Collections.emptyList();
    private boolean elementRequiredToBeSchemaValid = true;
    private Schema validationSchema;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<Resource> getSchemaResources() {
        return this.schemaResources;
    }

    public synchronized void setSchemaResources(@Nullable @NullableElements List<Resource> resources) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.schemaResources = ImmutableList.copyOf((Iterable)Iterables.filter(resources, (Predicate)Predicates.notNull()));
    }

    public boolean isElementRequiredToBeSchemaValid() {
        return this.elementRequiredToBeSchemaValid;
    }

    public synchronized void setElementRequiredToBeSchemaValid(boolean isRequired) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.elementRequiredToBeSchemaValid = isRequired;
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) throws StageProcessingException {
        this.log.debug("{} pipeline stage schema validating DOM Element collection elements", (Object)this.getId());
        Validator validator = this.validationSchema.newValidator();
        try {
            validator.validate(new DOMSource((Node)item.unwrap()));
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("DOM Element was not valid:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)((Node)item.unwrap())), (Object)e);
            }
            if (this.elementRequiredToBeSchemaValid) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), e.getMessage()));
            }
            item.getItemMetadata().put(new WarningStatus(this.getId(), e.getMessage()));
        }
        return true;
    }

    protected void doDestroy() {
        for (Resource schemaResource : this.schemaResources) {
            schemaResource.destroy();
        }
        this.schemaResources = null;
        this.validationSchema = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.schemaResources == null || this.schemaResources.isEmpty()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", SchemaResources may not be empty");
        }
        for (Resource schemaResource : this.schemaResources) {
            if (schemaResource.isInitialized()) continue;
            schemaResource.initialize();
        }
        try {
            this.log.debug("{} pipeline stage building validation schema resources", (Object)this.getId());
            this.validationSchema = SchemaBuilder.buildSchema((SchemaBuilder.SchemaLanguage)SchemaBuilder.SchemaLanguage.XML, (Resource[])this.schemaResources.toArray(new Resource[this.schemaResources.size()]));
        }
        catch (SAXException e) {
            throw new ComponentInitializationException("Unable to generate schema", (Exception)e);
        }
    }
}

