/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class XMLSignatureValidationStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XMLSignatureValidationStage.class);
    private boolean signatureRequired = true;
    private boolean validSignatureRequired = true;
    private Certificate verificationCertificate;
    private PublicKey verificationKey;

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public synchronized void setSignatureRequired(boolean required) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureRequired = required;
    }

    public boolean isValidSignatureRequired() {
        return this.validSignatureRequired;
    }

    public synchronized void setValidSignatureRequired(boolean isRequired) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validSignatureRequired = isRequired;
    }

    @Nullable
    public PublicKey getVerificationKey() {
        return this.verificationKey;
    }

    public synchronized void setVerificationKey(@Nonnull PublicKey key) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verificationKey = (PublicKey)Constraint.isNotNull((Object)key, (String)"Public key can not be null");
    }

    @Nullable
    public Certificate getVerificationCertificate() {
        return this.verificationCertificate;
    }

    public synchronized void setVerificationCertificate(@Nonnull Certificate certificate) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verificationCertificate = (Certificate)Constraint.isNotNull((Object)certificate, (String)"Certificate can not be null");
        this.verificationKey = this.verificationCertificate.getPublicKey();
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) throws StageProcessingException {
        Element signatureElement = this.getSignatureElement((Element)item.unwrap());
        if (signatureElement == null) {
            if (this.signatureRequired) {
                this.log.debug("DOM Element was not signed and signature is required");
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "DOM Element was not signed but signatures are required"));
            } else {
                this.log.debug("DOM Element is not signed, no verification performed");
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("DOM Element contained Signature element\n{}", (Object)SerializeSupport.prettyPrintXML((Node)signatureElement));
        }
        if (!this.signatureVerified(signatureElement)) {
            if (this.validSignatureRequired) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "element signature is invalid"));
            } else {
                item.getItemMetadata().put(new WarningStatus(this.getId(), "element signature is invalid"));
            }
        }
        return true;
    }

    protected boolean signatureVerified(@Nonnull Element signatureElement) throws StageProcessingException {
        XMLSignature signature;
        this.log.debug("Creating XML security library XMLSignature object");
        try {
            signature = new XMLSignature(signatureElement, "");
        }
        catch (XMLSecurityException e) {
            this.log.debug("Unable to read XML signature", (Throwable)e);
            return false;
        }
        try {
            if (signature.checkSignatureValue((Key)this.verificationKey)) {
                this.log.debug("DOM Element signature verified.");
                return true;
            }
            this.log.debug("DOM Element signature did not verify.");
            return false;
        }
        catch (XMLSignatureException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to validate signature", (Throwable)e);
            }
            return false;
        }
    }

    protected Element getSignatureElement(@Nonnull Element root) throws StageProcessingException {
        List sigElements = ElementSupport.getChildElementsByTagNameNS((Node)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (sigElements.isEmpty()) {
            return null;
        }
        if (sigElements.size() > 1) {
            throw new StageProcessingException("DOM Element contained more than one signature");
        }
        return (Element)sigElements.get(0);
    }

    protected void doDestroy() {
        this.verificationCertificate = null;
        this.verificationKey = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.verificationKey == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", no verification key was specified");
        }
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

