/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.shibboleth.metadata.dom.AbstractXSLProcessingStage;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.w3c.dom.Element;

@ThreadSafe
public class XSLValidationStage
extends AbstractXSLProcessingStage {
    @Override
    protected void executeTransformer(@Nonnull Transformer transformer, @Nonnull @NonnullElements Collection<DomElementItem> itemCollection) throws StageProcessingException, TransformerConfigurationException {
        try {
            for (DomElementItem domItem : itemCollection) {
                transformer.setErrorListener(new AbstractXSLProcessingStage.StatusInfoAppendingErrorListener(domItem));
                transformer.transform(new DOMSource(((Element)domItem.unwrap()).getOwnerDocument()), new DOMResult());
            }
        }
        catch (TransformerException e) {
            throw new StageProcessingException("Unable to validate DOM Element", e);
        }
    }
}

