/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class EntitiesDescriptorAssemblerStage
extends BaseStage<DomElementItem> {
    public static final QName NAME_ATTRIB_NAME = new QName("Name");
    private final Logger log = LoggerFactory.getLogger(EntitiesDescriptorAssemblerStage.class);
    private boolean noChildrenAProcessingError;
    private ItemOrderingStrategy orderingStrategy = new NoOpItemOrderingStrategy();
    private String descriptorName;

    public boolean isNoChildrenAProcessingError() {
        return this.noChildrenAProcessingError;
    }

    public synchronized void setNoChildrenAProcessingError(boolean isError) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noChildrenAProcessingError = isError;
    }

    @Nonnull
    public ItemOrderingStrategy getItemOrderingStrategy() {
        return this.orderingStrategy;
    }

    public synchronized void setItemOrderingStrategy(@Nonnull ItemOrderingStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.orderingStrategy = (ItemOrderingStrategy)Constraint.isNotNull((Object)strategy, (String)"Item ordering strategy can not be null");
    }

    @Nullable
    public String getDescriptorName() {
        return this.descriptorName;
    }

    public synchronized void setDescriptorName(@Nullable String name) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.descriptorName = StringSupport.trimOrNull((String)name);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection) throws StageProcessingException {
        if (itemCollection.isEmpty()) {
            if (this.noChildrenAProcessingError) {
                throw new StageProcessingException("Unable to assemble EntitiesDescriptor from an empty collection");
            }
            this.log.debug("Unable to assemble EntitiesDescriptor from an empty collection");
            return;
        }
        DOMImplementation domImpl = ((Element)itemCollection.iterator().next().unwrap()).getOwnerDocument().getImplementation();
        Document entitiesDescriptorDocument = domImpl.createDocument(null, null, null);
        Element entitiesDescriptor = ElementSupport.constructElement((Document)entitiesDescriptorDocument, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        entitiesDescriptorDocument.appendChild(entitiesDescriptor);
        this.addDescriptorName(entitiesDescriptor);
        ElementSupport.appendTextContent((Element)entitiesDescriptor, (String)"\n");
        List<DomElementItem> orderedItems = this.orderingStrategy.order(itemCollection);
        for (DomElementItem item : orderedItems) {
            Element descriptor = (Element)item.unwrap();
            if (!SamlMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) continue;
            descriptor = (Element)entitiesDescriptorDocument.importNode(descriptor, true);
            entitiesDescriptor.appendChild(descriptor);
            ElementSupport.appendTextContent((Element)entitiesDescriptor, (String)"\n");
        }
        DomElementItem item = new DomElementItem(entitiesDescriptorDocument);
        itemCollection.clear();
        itemCollection.add(item);
    }

    protected void addDescriptorName(@Nonnull Element entitiesDescriptor) {
        if (this.descriptorName != null) {
            AttributeSupport.appendAttribute((Element)entitiesDescriptor, (QName)NAME_ATTRIB_NAME, (String)this.descriptorName);
        }
    }

    protected void doDestroy() {
        this.orderingStrategy = null;
        this.descriptorName = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.orderingStrategy == null) {
            this.orderingStrategy = new NoOpItemOrderingStrategy();
        }
    }

    private class NoOpItemOrderingStrategy
    implements ItemOrderingStrategy {
        private NoOpItemOrderingStrategy() {
        }

        @Override
        public List<DomElementItem> order(@Nonnull @NonnullElements Collection<DomElementItem> items) {
            return new ArrayList<DomElementItem>(items);
        }
    }

    public static interface ItemOrderingStrategy {
        public List<DomElementItem> order(@Nonnull @NonnullElements Collection<DomElementItem> var1);
    }
}

