/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntitiesDescriptorDisassemblerStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(EntitiesDescriptorDisassemblerStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection) {
        ArrayList<DomElementItem> items = new ArrayList<DomElementItem>(itemCollection);
        itemCollection.clear();
        for (DomElementItem item : items) {
            Element element = (Element)item.unwrap();
            if (SamlMetadataSupport.isEntitiesDescriptor(element)) {
                this.processEntitiesDescriptor(itemCollection, element);
                continue;
            }
            if (SamlMetadataSupport.isEntityDescriptor(element)) {
                this.processEntityDescriptor(itemCollection, element);
                continue;
            }
            this.log.debug("{} pipeline stage: DOM Element {} not supported, ignoring it", (Object)this.getId(), (Object)QNameSupport.getNodeQName((Node)element));
        }
    }

    protected void processEntitiesDescriptor(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection, @Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            if (SamlMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(itemCollection, child);
            }
            if (!SamlMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(itemCollection, child);
        }
    }

    protected void processEntityDescriptor(@Nonnull @NonnullElements Collection<DomElementItem> itemCollection, @Nonnull Element entityDescriptor) {
        DomElementItem item = new DomElementItem(entityDescriptor);
        itemCollection.add(item);
    }
}

