/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityRegistrationAuthorityFilterStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(EntityRegistrationAuthorityFilterStage.class);
    private boolean requiringRegistrationInformation;
    private Collection<String> designatedAuthorities = Collections.emptyList();
    private boolean whitelistingAuthorities;
    private boolean removingEntitylessEntitiesDescriptor = true;

    public boolean isRequiringRegistrationInformation() {
        return this.requiringRegistrationInformation;
    }

    public synchronized void setRequiringRegistrationInformation(boolean isRequired) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiringRegistrationInformation = isRequired;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<String> getDesignatedRegistrationAuthorities() {
        return this.designatedAuthorities;
    }

    public synchronized void setDesignatedRegistrationAuthorities(@Nullable @NullableElements Collection<String> authorities) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.designatedAuthorities = authorities == null || authorities.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(authorities, (Predicate)Predicates.notNull()));
    }

    public boolean isWhitelistingRegistrationAuthorities() {
        return this.whitelistingAuthorities;
    }

    public synchronized void setWhitelistingRegistrationAuthorities(boolean whitelisting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistingAuthorities = whitelisting;
    }

    public boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    protected void doDestroy() {
        this.designatedAuthorities = null;
        super.doDestroy();
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntitiesDescriptor(descriptor)) {
            if (this.processEntitiesDescriptor(descriptor)) {
                return false;
            }
        } else if (SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return !this.filterOutDescriptor(descriptor);
        }
        return true;
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        Element descriptor;
        if (this.filterOutDescriptor(entitiesDescriptor)) {
            return true;
        }
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        Iterator descriptorItr = childEntitiesDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntitiesDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        descriptorItr = childEntityDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.filterOutDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        return this.removingEntitylessEntitiesDescriptor && childEntitiesDescriptors.isEmpty() && childEntityDescriptors.isEmpty();
    }

    protected boolean filterOutDescriptor(@Nonnull Element descriptor) {
        Element registrationInfoElement = SamlMetadataSupport.getDescriptorExtensions(descriptor, new QName("urn:oasis:names:tc:SAML:metadata:rpi", "RegistrationInfo"));
        if (registrationInfoElement == null) {
            if (this.requiringRegistrationInformation) {
                this.log.debug("{} pipeline stage removing Item because it did not have required registration information extension", (Object)this.getId());
                return true;
            }
            return false;
        }
        String registrationAuthority = AttributeSupport.getAttributeValue((Element)registrationInfoElement, null, (String)"registrationAuthority");
        if (registrationAuthority == null) {
            this.log.debug("{} pipeline stage removing Item because it contained a registration info extension but no authority attribute", (Object)this.getId());
            return true;
        }
        if (this.whitelistingAuthorities && !this.designatedAuthorities.contains(registrationAuthority)) {
            this.log.debug("{} pipeline stage removing Item because its registration authority was not on the whitelist", (Object)this.getId());
            return true;
        }
        if (!this.whitelistingAuthorities && this.designatedAuthorities.contains(registrationAuthority)) {
            this.log.debug("{} pipeline stage removing Item because its registration authority was on the blacklist", (Object)this.getId());
            return true;
        }
        return false;
    }
}

