/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.Type4UuidIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateIdStage
extends BaseIteratingStage<DomElementItem> {
    public static final QName ID_ATTRIB = new QName("ID");
    private final IdentifierGenerationStrategy idGenerator;

    public GenerateIdStage() {
        this.idGenerator = new Type4UuidIdentifierGenerationStrategy();
    }

    public GenerateIdStage(@Nonnull IdentifierGenerationStrategy generator) {
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"ID generation strategy can not be null");
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) throws StageProcessingException {
        Element element = (Element)item.unwrap();
        if (!SamlMetadataSupport.isEntityOrEntitiesDescriptor(element)) {
            return true;
        }
        Attr idAttribute = AttributeSupport.getAttribute((Element)element, (QName)ID_ATTRIB);
        if (idAttribute == null) {
            idAttribute = AttributeSupport.constructAttribute((Document)element.getOwnerDocument(), (QName)ID_ATTRIB);
            element.setAttributeNode(idAttribute);
        }
        idAttribute.setValue(this.idGenerator.generateIdentifier());
        return true;
    }
}

