/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.XMLSignatureSigningStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public final class SamlMetadataSupport {
    public static final String MD_NS = "urn:oasis:names:tc:SAML:2.0:metadata";
    public static final String MD_PREFIX = "md";
    public static final String RPI_NS = "urn:oasis:names:tc:SAML:metadata:rpi";
    public static final QName ENTITIES_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
    public static final QName ENTITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
    public static final QName EXTENSIONS_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions");
    public static final QName VALID_UNTIL_ATTIB_NAME = new QName("validUntil");
    public static final QName CACHE_DURATION_ATTRIB_NAME = new QName("cacheDuration");

    private SamlMetadataSupport() {
    }

    public static boolean isEntityOrEntitiesDescriptor(@Nullable Element e) {
        return SamlMetadataSupport.isEntitiesDescriptor(e) || SamlMetadataSupport.isEntityDescriptor(e);
    }

    public static boolean isEntitiesDescriptor(@Nullable Element e) {
        return ElementSupport.isElementNamed((Element)e, (QName)ENTITIES_DESCRIPTOR_NAME);
    }

    public static boolean isEntityDescriptor(@Nullable Element e) {
        return ElementSupport.isElementNamed((Element)e, (QName)ENTITY_DESCRIPTOR_NAME);
    }

    public static Element getDescriptorExtensions(@Nullable Element descriptor, @Nullable QName extensionName) {
        if (descriptor == null || extensionName == null || !SamlMetadataSupport.isEntitiesDescriptor(descriptor) && !SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return null;
        }
        List extensions = ElementSupport.getChildElements((Node)descriptor, (QName)EXTENSIONS_NAME);
        if (extensions.isEmpty()) {
            return null;
        }
        List results = ElementSupport.getChildElements((Node)((Node)extensions.get(0)), (QName)extensionName);
        if (results.isEmpty()) {
            return null;
        }
        return (Element)results.get(0);
    }

    public static void addDescriptorExtension(@Nullable Element descriptor, @Nullable Element extension) {
        Element extensionsElement;
        if (descriptor == null || extension == null) {
            return;
        }
        if (!SamlMetadataSupport.isEntitiesDescriptor(descriptor) && !SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return;
        }
        Map descriptorChildren = ElementSupport.getIndexedChildElements((Element)descriptor);
        List extensionsElements = (List)descriptorChildren.get(EXTENSIONS_NAME);
        if (extensionsElements.isEmpty()) {
            extensionsElement = ElementSupport.constructElement((Document)descriptor.getOwnerDocument(), (QName)EXTENSIONS_NAME);
            Element insertExtensionsElementBefore = null;
            List signatureElements = (List)descriptorChildren.get(XMLSignatureSigningStage.SIGNATURE_NAME);
            if (!signatureElements.isEmpty()) {
                Element lastSignatureElement = (Element)signatureElements.get(signatureElements.size() - 1);
                insertExtensionsElementBefore = ElementSupport.getNextSiblingElement((Node)lastSignatureElement);
            } else {
                insertExtensionsElementBefore = ElementSupport.getFirstChildElement((Node)descriptor);
            }
            if (insertExtensionsElementBefore == null) {
                descriptor.appendChild(extensionsElement);
            } else {
                descriptor.insertBefore(extensionsElement, insertExtensionsElementBefore);
            }
        } else {
            extensionsElement = (Element)extensionsElements.get(0);
        }
        ElementSupport.appendChildElement((Element)extensionsElement, (Element)extension);
    }
}

