/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetCacheDurationStage
extends BaseIteratingStage<DomElementItem> {
    private long cacheDuration;

    public long getCacheDuration() {
        return this.cacheDuration;
    }

    public synchronized void setCacheDuration(long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cacheDuration = duration;
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.cacheDuration);
        }
        return true;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cacheDuration <= 0L) {
            throw new ComponentInitializationException("Cache duration must be greater than 0");
        }
    }
}

