/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetValidUntilStage
extends BaseIteratingStage<DomElementItem> {
    private long validityDuration;

    public long getValidityDuration() {
        return this.validityDuration;
    }

    public synchronized void setValidityDuration(long duration) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validityDuration = duration;
    }

    @Override
    protected boolean doExecute(@Nonnull DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME, (long)(System.currentTimeMillis() + this.validityDuration));
        }
        return true;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.validityDuration <= 0L) {
            throw new ComponentInitializationException("Validity duration must be greater than 0");
        }
    }
}

