/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractDestructableIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

@ThreadSafe
public abstract class BaseStage<ItemType extends Item<?>>
extends AbstractDestructableIdentifiableInitializableComponent
implements Stage<ItemType> {
    public synchronized void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    @Override
    public void execute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws StageProcessingException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentInfo compInfo = new ComponentInfo(this);
        this.doExecute(itemCollection);
        ItemMetadataSupport.addToAll(itemCollection, Collections.singleton(compInfo));
        compInfo.setCompleteInstant();
    }

    protected abstract void doExecute(@Nonnull @NonnullElements Collection<ItemType> var1) throws StageProcessingException;
}

