/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.AbstractDestructableIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

@ThreadSafe
public class CompositeStage<ItemType extends Item<?>>
extends AbstractDestructableIdentifiableInitializableComponent
implements Stage<ItemType> {
    private List<Stage<ItemType>> composedStages = Collections.emptyList();

    public synchronized void setId(String componentId) {
        super.setId(componentId);
    }

    @Nonnull
    @NonnullElements
    public List<Stage<ItemType>> getComposedStages() {
        return this.composedStages;
    }

    public synchronized void setComposedStages(@Nullable @NullableElements List<Stage<ItemType>> stages) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ArrayList<Stage<ItemType>> newStages = new ArrayList<Stage<ItemType>>();
        if (stages != null) {
            for (Stage<ItemType> stage : stages) {
                if (stage == null) continue;
                newStages.add(stage);
            }
        }
        this.composedStages = Collections.unmodifiableList(newStages);
    }

    @Override
    public void execute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws StageProcessingException {
        for (Stage<ItemType> stage : this.composedStages) {
            stage.execute(itemCollection);
        }
    }

    protected void doDestroy() {
        this.composedStages = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.composedStages == null || this.composedStages.isEmpty()) {
            this.composedStages = Collections.emptyList();
        }
    }
}

