/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class PipelineMergeStage
extends BaseStage<Item<?>> {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Supplier<Collection> collectionFactory = new SimpleItemCollectionFactory();
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();
    private List<Pipeline<? extends Item<?>>> mergedPipelines = Collections.emptyList();

    @Nonnull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(@Nonnull ExecutorService service) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.executorService = (ExecutorService)Constraint.isNotNull((Object)service, (String)"ExecutorService can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<Pipeline<? extends Item<?>>> getMergedPipelines() {
        return this.mergedPipelines;
    }

    public synchronized void setMergedPipelines(@Nullable @NullableElements List<? extends Pipeline<? extends Item<?>>> pipelines) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergedPipelines = pipelines == null || pipelines.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(pipelines, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    public Supplier<Collection> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<Collection> factory) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory may not be null");
    }

    @Nonnull
    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergeStrategy = strategy;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<?>> itemCollection) throws StageProcessingException {
        ArrayList<Future<Collection<? extends Item>>> pipelineResultFutures = new ArrayList<Future<Collection<? extends Item>>>();
        for (Pipeline<? extends Item<?>> pipeline : this.mergedPipelines) {
            pipelineResultFutures.add(this.executorService.submit(new PipelineCallable(pipeline, (Collection)this.collectionFactory.get())));
        }
        ArrayList pipelineResults = new ArrayList();
        for (Future future : pipelineResultFutures) {
            try {
                pipelineResults.add(future.get());
            }
            catch (ExecutionException e) {
                throw new StageProcessingException(e);
            }
            catch (InterruptedException e) {
                throw new StageProcessingException(e);
            }
        }
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults.toArray(new Collection[pipelineResults.size()]));
    }

    protected void doDestroy() {
        this.executorService = null;
        this.collectionFactory = null;
        this.mergeStrategy = null;
        this.mergedPipelines = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Pipeline<? extends Item<?>> pipeline : this.mergedPipelines) {
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

