/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScriptletStage
extends BaseStage<Item<?>> {
    public static final String ITEMS = "items";
    private final Logger log = LoggerFactory.getLogger(ScriptletStage.class);
    private EvaluableScript script;

    @Nullable
    public EvaluableScript getScript() {
        return this.script;
    }

    public synchronized void setScript(@Nonnull EvaluableScript stageScript) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)stageScript, (String)"Stage script can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<?>> itemCollection) throws StageProcessingException {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute(ITEMS, itemCollection, 100);
        try {
            this.script.eval((ScriptContext)context);
        }
        catch (ScriptException e) {
            String errMsg = this.getId() + " pipeline stage unable to execute script";
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.script == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", script may not be null");
        }
    }
}

