/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SerializationStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private final Logger log = LoggerFactory.getLogger(SerializationStage.class);
    private File outputFile;
    private boolean overwritingExistingOutputFile = true;
    private ItemSerializer<ItemType> serializer;

    @Nullable
    public File getOutputFile() {
        return this.outputFile;
    }

    public synchronized void setOutputFile(@Nonnull File file) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.outputFile = (File)Constraint.isNotNull((Object)file, (String)"Output file can not be null");
    }

    public boolean isOverwritingExistingOutputFile() {
        return this.overwritingExistingOutputFile;
    }

    public synchronized void setOverwritingExistingOutputFile(boolean isOverwriting) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.overwritingExistingOutputFile = isOverwriting;
    }

    @Nullable
    public ItemSerializer<ItemType> getSerializer() {
        return this.serializer;
    }

    public synchronized void setSerializer(@Nonnull ItemSerializer<ItemType> itemSerializer) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.serializer = (ItemSerializer)Constraint.isNotNull(itemSerializer, (String)"Item serializer can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws StageProcessingException {
        try {
            this.serializer.serialize(itemCollection, new FileOutputStream(this.outputFile));
        }
        catch (IOException e) {
            throw new StageProcessingException("Error write to output file " + this.outputFile.getAbsolutePath(), e);
        }
    }

    protected void doDestroy() {
        this.outputFile = null;
        this.serializer = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outputFile == null) {
            throw new ComponentInitializationException("Output file can not be null");
        }
        if (this.outputFile.exists()) {
            if (!this.overwritingExistingOutputFile) {
                throw new ComponentInitializationException("Output file '" + this.outputFile.getAbsolutePath() + "' exist and stage is configured not to overwrite the file");
            }
            if (!this.outputFile.canWrite()) {
                throw new ComponentInitializationException("Can not write to output file '" + this.outputFile.getAbsolutePath() + "'");
            }
        } else {
            File parentDirectory = this.outputFile.getParentFile();
            if (parentDirectory != null) {
                if (!parentDirectory.canWrite()) {
                    throw new ComponentInitializationException("Can not write to parent directory of output file '" + this.outputFile.getAbsolutePath() + "'");
                }
            } else {
                this.log.warn("Unable to determine parent directory for output file {}, this may result in a problem during stage execution", (Object)this.outputFile.getAbsolutePath());
            }
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Item serializer can not be null");
        }
    }
}

