/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineProcessingException;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractDestructableIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

@ThreadSafe
public class SimplePipeline<ItemType extends Item<?>>
extends AbstractDestructableIdentifiableInitializableComponent
implements Pipeline<ItemType> {
    private List<? extends Stage<ItemType>> pipelineStages = Collections.emptyList();

    public synchronized void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<? extends Stage<ItemType>> getStages() {
        return this.pipelineStages;
    }

    public synchronized void setStages(List<? extends Stage<ItemType>> stages) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.pipelineStages = stages == null || stages.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(stages, (Predicate)Predicates.notNull()));
    }

    @Override
    public void execute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws PipelineProcessingException {
        ComponentInfo compInfo = new ComponentInfo(this);
        for (Stage<ItemType> stage : this.pipelineStages) {
            stage.execute(itemCollection);
        }
        compInfo.setCompleteInstant();
        ItemMetadataSupport.addToAll(itemCollection, Collections.singleton(compInfo));
    }

    protected void doDestroy() {
        this.pipelineStages = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Stage<ItemType> stage : this.pipelineStages) {
            if (stage.isInitialized()) continue;
            stage.initialize();
        }
    }
}

