/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SplitMergeStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private final Logger log = LoggerFactory.getLogger(SplitMergeStage.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Supplier<Collection<ItemType>> collectionFactory = new SimpleItemCollectionFactory();
    private Predicate<ItemType> selectionStrategy = Predicates.alwaysFalse();
    private Pipeline<ItemType> selectedItemPipeline;
    private Pipeline<ItemType> nonselectedItemPipeline;
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();

    @Nonnull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(@Nonnull ExecutorService service) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.executorService = (ExecutorService)Constraint.isNotNull((Object)service, (String)"ExecutorService can not be null");
    }

    @Nonnull
    public Supplier<Collection<ItemType>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<Collection<ItemType>> factory) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory can not be null");
    }

    @Nonnull
    public Predicate<ItemType> getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public synchronized void setSelectionStrategy(@Nonnull Predicate<ItemType> strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selectionStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Item selection strategy can not be null");
    }

    @Nullable
    public Pipeline<ItemType> getSelectedItemPipeline() {
        return this.selectedItemPipeline;
    }

    public synchronized void setSelectedItemPipeline(@Nullable Pipeline<ItemType> pipeline) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selectedItemPipeline = pipeline;
    }

    @Nullable
    public Pipeline<ItemType> getNonselectedItemPipeline() {
        return this.nonselectedItemPipeline;
    }

    public synchronized void setNonselectedItemPipeline(@Nullable Pipeline<ItemType> pipeline) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nonselectedItemPipeline = pipeline;
    }

    @Nonnull
    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mergeStrategy = (CollectionMergeStrategy)Constraint.isNotNull((Object)strategy, (String)"Collection merge strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws StageProcessingException {
        Collection selectedItems = (Collection)this.collectionFactory.get();
        Collection nonselectedItems = (Collection)this.collectionFactory.get();
        for (Item<?> item : itemCollection) {
            if (item == null) continue;
            if (this.selectionStrategy.apply(item)) {
                selectedItems.add(item.copy());
                continue;
            }
            nonselectedItems.add(item.copy());
        }
        Future<Collection<Item>> selectedItemFuture = this.executePipeline(this.selectedItemPipeline, selectedItems);
        Future<Collection<Item>> future = this.executePipeline(this.nonselectedItemPipeline, nonselectedItems);
        ArrayList<Collection> pipelineResults = new ArrayList<Collection>();
        try {
            if (selectedItemFuture != null) {
                pipelineResults.add(selectedItemFuture.get());
            } else {
                pipelineResults.add(selectedItems);
            }
            if (future != null) {
                pipelineResults.add(future.get());
            } else {
                pipelineResults.add(nonselectedItems);
            }
        }
        catch (ExecutionException e) {
            this.log.error("Pipeline threw an unexpected exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error("Execution service was interrupted", (Throwable)e);
        }
        itemCollection.clear();
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults.toArray(new Collection[pipelineResults.size()]));
    }

    @Nonnull
    protected Future<Collection<? extends Item>> executePipeline(Pipeline<ItemType> pipeline, Collection<ItemType> items) {
        if (pipeline == null) {
            return null;
        }
        PipelineCallable callable = new PipelineCallable(pipeline, items);
        return this.executorService.submit(callable);
    }

    protected void doDestroy() {
        this.executorService = null;
        this.collectionFactory = null;
        this.selectionStrategy = null;
        this.selectedItemPipeline = null;
        this.nonselectedItemPipeline = null;
        this.mergeStrategy = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selectedItemPipeline == null && this.nonselectedItemPipeline == null) {
            throw new ComponentInitializationException(this.getId() + " selected and non-selected pipelines are null");
        }
        if (this.selectedItemPipeline != null && !this.selectedItemPipeline.isInitialized()) {
            this.log.debug("Selected item pipeline was not initialized, initializing it now.");
            this.selectedItemPipeline.initialize();
        }
        if (this.nonselectedItemPipeline != null && !this.nonselectedItemPipeline.isInitialized()) {
            this.log.debug("Non-selected item pipeline was not initialized, initializing it now.");
            this.nonselectedItemPipeline.initialize();
        }
    }
}

