/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

@ThreadSafe
public class StaticItemSourceStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private Collection<ItemType> source = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<ItemType> getSourceItems() {
        return this.source;
    }

    public synchronized void setSourceItems(@Nullable @NullableElements Collection<ItemType> items) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.source = items == null || items.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(items, (Predicate)Predicates.notNull()));
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<ItemType> itemCollection) throws StageProcessingException {
        for (Item items : this.getSourceItems()) {
            if (items == null) continue;
            itemCollection.add(items.copy());
        }
    }

    protected void doDestroy() {
        this.source = null;
        super.doDestroy();
    }
}

