/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class BaseTest {
    protected final Class<?> testingClass;
    private final String baseClassPath;
    private final Package testingPackage;
    private final String basePackagePath;

    protected BaseTest(Class<?> clazz) {
        this.testingClass = clazz;
        this.baseClassPath = this.nameToPath(this.testingClass.getName());
        this.testingPackage = this.testingClass.getPackage();
        this.basePackagePath = this.nameToPath(this.testingPackage.getName()) + "/";
    }

    private String nameToPath(String name) {
        return "/" + name.replace('.', '/');
    }

    protected String classRelativeResource(String which) {
        return this.baseClassPath + "-" + which;
    }

    protected String simpleClassRelativeName(String which) {
        return this.testingClass.getSimpleName() + "-" + which;
    }

    protected String packageRelativeResource(String which) {
        return this.basePackagePath + which;
    }

    public Resource getClasspathResource(String resourcePath) {
        return new ClassPathResource(this.simpleClassRelativeName(resourcePath), this.testingClass);
    }
}

