/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.MockItem;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FirstItemIdItemIdentificationStrategyTest {
    @Test
    public void unidentified() {
        FirstItemIdItemIdentificationStrategy strat = new FirstItemIdItemIdentificationStrategy();
        Assert.assertEquals((String)strat.getNoItemIdIdentifier(), (String)"unidentified");
        MockItem item = new MockItem("item");
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"unidentified");
    }

    @Test
    public void setNoItemIdIdentifier() {
        FirstItemIdItemIdentificationStrategy strat = new FirstItemIdItemIdentificationStrategy();
        strat.setNoItemIdIdentifier("mu");
        Assert.assertEquals((String)strat.getNoItemIdIdentifier(), (String)"mu");
        MockItem item = new MockItem("item");
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"mu");
    }

    @Test
    public void oneIdentifier() {
        FirstItemIdItemIdentificationStrategy strat = new FirstItemIdItemIdentificationStrategy();
        MockItem item = new MockItem("item");
        item.getItemMetadata().put((Object)new ItemId("id"));
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"id");
    }

    @Test
    public void twoIdentifiers() {
        FirstItemIdItemIdentificationStrategy strat = new FirstItemIdItemIdentificationStrategy();
        MockItem item = new MockItem("item");
        item.getItemMetadata().put((Object)new ItemId("first"));
        item.getItemMetadata().put((Object)new ItemId("second"));
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"first");
    }
}

