/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.SimpleItemCollectionSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleItemCollectionSerializerTest {
    @Test
    public void serializeCollection() {
        MockItem i1 = new MockItem("one");
        MockItem i2 = new MockItem("two");
        MockItem i3 = new MockItem("three");
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(i1);
        items.add(i2);
        items.add(i3);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ItemSerializer<String> base = new ItemSerializer<String>(){

            public void serialize(Item<String> item, OutputStream output) {
                try {
                    output.write(((String)item.unwrap()).getBytes());
                }
                catch (IOException e) {
                    Assert.fail((String)"exception in string serializer", (Throwable)e);
                }
            }
        };
        SimpleItemCollectionSerializer ics = new SimpleItemCollectionSerializer((ItemSerializer)base);
        ics.serializeCollection(items, (OutputStream)output);
        Assert.assertEquals((byte[])output.toByteArray(), (byte[])new byte[]{111, 110, 101, 116, 119, 111, 116, 104, 114, 101, 101});
    }
}

