/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.AbstractDOMValidationStage;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.metadata.validate.Validator;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class AbstractDOMValidationStageTest
extends BaseDOMTest {
    protected AbstractDOMValidationStageTest() {
        super(AbstractDOMValidationStage.class);
    }

    @Test
    public void testEarlyCompletion() throws Exception {
        FirstStringValidator v1 = new FirstStringValidator();
        v1.setId("v1");
        v1.initialize();
        UnexecutedStringValidator v2 = new UnexecutedStringValidator();
        v2.setId("v2");
        v2.initialize();
        ArrayList<BaseValidator> validators = new ArrayList<BaseValidator>();
        validators.add(v1);
        validators.add(v2);
        StringValidationStage s1 = new StringValidationStage();
        s1.setId("s1");
        s1.setValidators(validators);
        s1.initialize();
        Item<Element> i1 = this.readDOMItem("early.xml");
        ArrayList<Item<Element>> items = new ArrayList<Item<Element>>();
        items.add(i1);
        s1.execute(items);
        Assert.assertEquals((int)2, (int)this.countErrors(i1));
        List errors = i1.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((String)((ErrorStatus)errors.get(0)).getStatusMessage(), (String)"element contains one");
        Assert.assertEquals((String)((ErrorStatus)errors.get(1)).getStatusMessage(), (String)"element contains two");
    }

    private static class UnexecutedStringValidator
    extends BaseValidator
    implements Validator<String> {
        private UnexecutedStringValidator() {
        }

        public Validator.Action validate(String e, Item<?> item, String stageId) throws StageProcessingException {
            Assert.fail((String)"should not execute this");
            return Validator.Action.CONTINUE;
        }
    }

    private static class FirstStringValidator
    extends BaseValidator
    implements Validator<String> {
        private FirstStringValidator() {
        }

        public Validator.Action validate(String e, Item<?> item, String stageId) throws StageProcessingException {
            this.addError("element contains " + e, item, stageId);
            return Validator.Action.DONE;
        }
    }

    private static class StringValidationStage
    extends AbstractDOMValidationStage<String> {
        private StringValidationStage() {
        }

        protected boolean applicable(Element element) {
            return "checkedElement".equals(element.getLocalName());
        }

        protected void visit(Element element, AbstractDOMTraversalStage.TraversalContext context) throws StageProcessingException {
            this.applyValidators(element.getTextContent(), context);
        }
    }
}

