/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.InputStream;
import java.util.List;
import net.shibboleth.metadata.BaseTest;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseDOMTest
extends BaseTest {
    private BasicParserPool parserPool;

    protected BaseDOMTest(Class<?> clazz) {
        super(clazz);
    }

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
    }

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public Element readXMLData(String path) throws XMLParserException {
        InputStream input;
        String trimmedPath = StringSupport.trimOrNull((String)path);
        Constraint.isNotNull((Object)trimmedPath, (String)"Path may not be null or empty");
        if (!trimmedPath.startsWith("/")) {
            trimmedPath = this.classRelativeResource(trimmedPath);
        }
        if ((input = BaseDOMTest.class.getResourceAsStream(trimmedPath)) == null) {
            throw new XMLParserException(trimmedPath + " does not exist or is not readable");
        }
        return this.parserPool.parse(input).getDocumentElement();
    }

    public Item<Element> readDOMItem(String path) throws XMLParserException {
        Element e = this.readXMLData(path);
        return new DOMElementItem(e);
    }

    public void assertXMLIdentical(Node expected, Node actual) {
        Constraint.isNotNull((Object)expected, (String)"Expected Node may not be null");
        Constraint.isNotNull((Object)actual, (String)"Actual Node may not be null");
        Diff diff = new Diff(expected.getOwnerDocument(), actual.getOwnerDocument());
        if (!diff.identical()) {
            Assert.fail((String)diff.toString());
        }
    }

    protected int countErrors(Item<Element> item) {
        ClassToInstanceMultiMap metadata = item.getItemMetadata();
        List errors = metadata.get(ErrorStatus.class);
        return errors.size();
    }
}

