/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.CRDetectionStage;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CRDetectionStageTest
extends BaseDOMTest {
    public CRDetectionStageTest() throws Exception {
        super(CRDetectionStage.class);
    }

    @Test
    public void testDocumentAssumptions() throws Exception {
        Item<Element> item = this.readDOMItem("assumptions.xml");
        Element doc = (Element)item.unwrap();
        Assert.assertEquals((String)doc.getTagName(), (String)"root");
        Node node = doc.getFirstChild();
        Assert.assertEquals((String)node.getNodeValue(), (String)"text\rtext");
        Element foo = (Element)node.getNextSibling();
        String fop = foo.getAttribute("fop");
        Assert.assertEquals((String)fop, (String)"x\ry");
    }

    @Test
    public void testCommentAssumptions() throws Exception {
        BasicParserPool commentingParserPool = new BasicParserPool();
        commentingParserPool.setIgnoreComments(false);
        commentingParserPool.initialize();
        InputStream input = this.getClasspathResource("comment.xml").getInputStream();
        Assert.assertNotNull((Object)input);
        Element doc = commentingParserPool.parse(input).getDocumentElement();
        Assert.assertEquals((String)doc.getTagName(), (String)"root");
        Node node1 = doc.getFirstChild();
        Assert.assertEquals((short)node1.getNodeType(), (short)3);
        Node node2 = node1.getNextSibling();
        Assert.assertEquals((short)node2.getNodeType(), (short)8);
        Comment comment = (Comment)node2;
        Assert.assertEquals((String)comment.getData(), (String)" a comment incorporating a &#13; ");
    }

    private List<ErrorStatus> execute(Item<Element> item) throws Exception {
        ArrayList<Item<Element>> itemCollection = new ArrayList<Item<Element>>();
        itemCollection.add(item);
        CRDetectionStage stage = new CRDetectionStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(itemCollection);
        List warnings = item.getItemMetadata().get(WarningStatus.class);
        Assert.assertTrue((boolean)warnings.isEmpty());
        List infos = item.getItemMetadata().get(InfoStatus.class);
        Assert.assertTrue((boolean)infos.isEmpty());
        return item.getItemMetadata().get(ErrorStatus.class);
    }

    private List<ErrorStatus> execute(String filename) throws Exception {
        Item<Element> item = this.readDOMItem(filename);
        return this.execute(item);
    }

    private void expectError(String filename, String errorContains) throws Exception {
        List<ErrorStatus> errors = this.execute(filename);
        Assert.assertEquals((int)errors.size(), (int)1, (String)("errors size on " + filename));
        ErrorStatus error = errors.get(0);
        Assert.assertTrue((boolean)error.getStatusMessage().contains(errorContains), (String)(filename + " does not contain " + errorContains));
    }

    @Test
    public void testErrors() throws Exception {
        this.expectError("element.xml", "element");
        this.expectError("attribute.xml", "attribute");
        this.expectError("assumptions.xml", "carriage return");
        this.expectError("nested-element.xml", "element");
        this.expectError("nested-attribute.xml", "attribute");
        this.expectError("multiple.xml", "element");
    }

    @Test
    public void testOK() throws Exception {
        List<ErrorStatus> errors = this.execute("ok.xml");
        Assert.assertTrue((boolean)errors.isEmpty());
    }
}

